(unless (boundp '*demo-control-panel)
        (setf *demo-control-panel* nil)
        (setf *univar-control-panel* nil)
        (setf *datavis-control-panel* nil)
        
        (setf *datavis-demo-data-loaded* nil)
        (setf *univar-demo-data-loaded* nil)
        (setf *princomp-demo-data-loaded* nil)
        (setf *all-demo-data-loaded* nil)
        (setf *bc-demo-data-loaded* nil)
        (setf *demo-data-path* (strcat *default-path* "help\\demos\\datademo\\"))
        (setf *datademo-data-path* (strcat *default-path* "help\\demos\\datademo\\"))
        (defun load-datasets (datasets-list)
          (unless *all-demo-data-loaded* 
                  (let ((indir (get-working-directory)))
                    (set-working-directory *demo-data-path*)
                    (mapcar #'(lambda (file) 
                                (load-data (strcat *demo-data-path* file)))
                            datasets-list)
                    (set-working-directory indir))))
        )



(defun datavis-control-panel ()
  (ignore-errors (when *help-control-panel* (send *help-control-panel* :close)))
  (ignore-errors (when *menu-item-help-control-panel* (send *menu-item-help-control-panel* :close)))
  (ignore-errors (when *welcome-control-panel* (send *welcome-control-panel* :close)))
  (when *welcome-control-panel* (send *welcome-control-panel* :close))
  (unless *datavis-demo-data-loaded*
          (load-datasets 
           (list "p309799.lsp" "fish.lsp" "doctrats.lsp" "category.lsp" "titanic.lsp"))
          (unless *princomp-demo-data-loaded*
                  (load-datasets (list "crime.lsp" "p309799.lsp"))
                  (setf *princomp-demo-data-loaded* t))
          (setf *datavis-demo-data-loaded* t))
  (let*  ((dialog (choice-item-dialog (format nil "Choose a Visualization:~%Then use the SpreadPlots~%Help Boxes and Help Menus")
                 (list "Visualize Univariate Data" 
                       "Visualize Bivariate Data" 
                       "Visualize Multivariate Data" 
                       "Visualize CrossTabs Data" 
                       "Visualize Classification Data" 
                       "Visualize Frequency Data" 
                       "Visualize Categorical Data"
                       "End Demonstration")
                 (list '(do-uni) '(do-bi) '(do-multi) '(do-crstab)
                       '(do-class) '(do-freq) '(do-cat) '(end-datavisdemo))
                                      :show nil
                                      :title "Visualizations"))
          )
    (setf *datavis-control-panel* dialog)
    (send dialog :show-window)
    (send dialog :size 170 (second (send dialog :size)))
    (if *demo-control-panel* 
        (send dialog :location
              (first (- (send *demo-control-panel* :location) 20))
              (second (- (send *demo-control-panel* :location) 20)))
        (apply #'send dialog :location 
               (- (effective-screen-size) 
                  (send dialog :size) '(4 4))))
    ))




(defun demo-control-panel ()
  (let ((dialog))
    (ignore-errors (when *help-control-panel* (send *help-control-panel* :close)))
    (ignore-errors (when *menu-item-help-control-panel* (send *menu-item-help-control-panel* :close)))
    (ignore-errors (when *welcome-control-panel* (send *welcome-control-panel* :close)))
    (setf dialog
          (choice-item-dialog 
             (format nil "Choose A Demonstration~%Then follow the instructions")
             '("GETTING STARTED How to Use ViSta"
               "EXPLORATION.....Data Visualizations"
               "VISUALIZATION ..All Plots of Your Data"
               "TRANSFORMATION..Box-Cox Visualization"
               "INFERENCE.......The Central Limit Theorem"
               "REGRESSION......Influential Observations"
               "REGRESSION......Restriction of Range" 
               "UNIVARIATE......Univariate Analyses" 
               "MULTIVARIATE....Principal Components" 
               "MULTIVARIATE....Multivariate Regression"
               )
             (list
              '(VISTA-CHOICE-STRIP-APPLET)
              '(datavis-control-panel)
              '(progn (load (strcat *datademo-data-path* "boxcox-splom.lsp")))
              '(progn (load (strcat *datademo-data-path* "allplots.lsp")))
              '(progn (load (strcat *datademo-data-path* "simulate.lsp")))
              '(progn (load (strcat *datademo-data-path* "corrdemo.lsp"))
                      (reg-demo mathsat gpa "influence"))
              '(progn (load (strcat *datademo-data-path* "corrdemo.lsp"))
                      (reg-demo mathsat gpa "range"))
              '(progn (load (strcat *datademo-data-path* "univar.lsp")))
              '(progn (load (strcat *datademo-data-path* "princomp-crime.lsp")))
              '(progn (load (strcat *datademo-data-path* "princomp-car.lsp")))
              )
             :title "Demonstrations"))
    (send dialog :size 250 (second (send dialog :size)))
    (send dialog :location 
	(- (first (effective-screen-size)) 250) 
	(- (second (effective-screen-size)) (second (send dialog :size))))
    (setf *demo-control-panel* dialog)
    ))


;(start :show-desktop t
;       :show-logo t
;       :action #'demo-control-panel)


(setf *demosp* nil)
(setf *demo-postit* nil)

  
(defun follow-up (message &key title)
  (post-it message :title title :fit t)
  (when *demosp* (send *demosp* :close))
  (setf *demosp* *current-spreadplot*)
  (defmeth *demosp* :close ()
    (setf *demosp* nil)
    (call-next-method))
  )
  
(defun getready (data)
  (setcd data)
  (select-observations nil)
  (select-variables nil)
  )
         
(defun end-datavisdemo ()
  (when *datavis-control-panel* (send *datavis-control-panel* :close))
  (when *demo-postit* (send *demo-postit* :close))
  (when *demosp* (send *demosp* :close))
  )

     
(defun do-uni ()
  (let ((old-splot *demosp*))
    (getready p309799)
    (select-variables '("GPA"))
    (visualize-data :univariate t)
    (follow-up "The univariate visualization is for data with one numeric variable. Use the help boxes and help menu for more information." :title "Univariate Data Visualization")))
     
(defun do-bi ()
  (let ((old-splot *demosp*))
    (getready p309799)
    (select-variables '("SATMath" "SATVerb"))
    (visualize-data :bivariate t)
    (follow-up "The bivariate visualization is for data with two numeric variables. Use the help boxes and help menu for more information." :title "Bivariate Data Visualization")))


(defun do-multi ()
  (let ((old-splot *demosp*))
    (getready p309799)
    (visualize-data :multivariate t)
    (follow-up  "The multivariate visualization is for data with 3 or more numeric variables. Use the help boxes and help menu for more information." :title "Multivariate Data Visualization" :show-time 15 )))


     
(defun do-tour ()
  (let ((old-splot *demosp*))
    (getready fish)
    (visualize-data :tour t)
    (follow-up "The Guided Tour Visualization is an optional high-dimensional visualization for multivariate data which have 6 or more numeric variables. Use the help boxes and help menu for more information. Click to Close." :title "Guided Tour Data Visualization" :show-time 15)))


     
(defun do-crstab ()
  (let ((old-splot *demosp*))
    (getready p309799)
    (select-variables '("Age" "GPA" "SATMath" "SATVerb" "Degree" "Gender" "Wave"))
    (visualize-data :crosstabs t)
    (follow-up  (format nil "The crosstabs visualization is for data with at least one numeric and two category variables. Use the help boxes and help menu for more information.~2%Click to Close.") :title "Crosstabulation Visualization" :show-time 15)))


(defun do-class ()
  (let ((old-splot *demosp*))
    (getready p309799)
    (select-variables '("GPA" "Gender" "Wave"))
    (visualize-data :classification t)
    (follow-up  "The classification visualization is for classification data (data which have a numeric variable that is classified by one or more category variables). Use the help boxes and help menu for more information." :title "Classification Data Visualization" :show-time 15)))

     
(defun do-freq ()
  (let ((old-splot *demosp*))
    (getready titanic)
    (visualize-data :freq t)
    (follow-up  "The frequency visualization is for frequency data (data which have numeric variables that specify frequency values). Use the help boxes and help menu for more information." :title "Frequency Data Visualization" :show-time 15)))

     
(defun do-cat ()
  (let ((old-splot *demosp*))
    (getready p30catvar)
    (visualize-data :category t)
    (follow-up "The category visualization is for category data (data which have one or more category variables and no numeric variables)." :title "Category Data Visualization" :show-time 15)))


(setf previous-window nil)

(defun get-help ()
  (send (help (format nil "This GuideBar will guide you through the standard series of steps involved in the analysis and visualization of data. ~2%The first step is to bring the  data to be analyzed into ViSta. This is called \"Opening Data\".~2%After you click on the OPEN DATA button you will see a dialog box for locating your data.  After you choose a set of data the choices presented to you in the dialog box will expand.")) :show-window))

(defun 5-model-data ()
  (setco $)
  (analyze-data)
  (visualize-model)
  (send *analysis-dialog-strip* :size 114 260))

(defun 2-load-data ()
  (set-working-directory *user-path*)
  (load-data)
  (edit-data)
  (send *analysis-dialog-strip* :size 114 130))

(defun 3-report-data ()
  (when previous-window (send previous-window :close))
  (setf previous-window (send $ :report))
  (send *analysis-dialog-strip* :size 114 150))

(defun 4-view-data ()
  (when previous-window (send previous-window :close))
  (visualize-data :dialog t)
  (setf previous-wiindow (visualize-data :dialog t)))

(defun data-analysis-strip ()
  (let* ((ads
              (button-dialog nil 
                 (list "  Get Help        | Help"
                       "1 Open Data       | Help"
                       "2 Report Data     | Help"
                       "3 Visualize Data  | Help" 
                       "4 Model Data      | Help" 
                       "5 Visualize Model | Help"
                       "7 Report Model    | Help" 
                       "8 Save Model      | Help"
                       "  Close GuideBar  | Help"
                       "  Exit ViSta      | Help") 
                 (list '1-get-help 
                       '2-load-data
                       '3-report-data
                       '4-view-data
                       'applet-model-data  
                       'report-model 
                       'save-model
                       'close-dialog
                       'vista-exit)
               :cancel nil
               :title "ViSta GuideBar")))
    (defun close-dialog ()
      (send *analysis-dialog-strip* :close))
     (setf *analysis-dialog-strip*  ads)
     (send *analysis-dialog-strip* :size 114 70)
     (send *analysis-dialog-strip* :location (- (first (screen-size)) 114) 100)
     *analysis-dialog-strip*))



(demo-control-panel)